/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.exprcomp.test;

import filenet.vw.api.VWFieldType;
import filenet.vw.base.exprcomp.Distributions;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWExpr;
import filenet.vw.base.exprcomp.test.ATimer;
import filenet.vw.base.exprcomp.test.TestFieldColImpl;
import filenet.vw.base.exprcomp.test.TestFieldImpl;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class jvwexptst {
    static TestFieldColImpl fieldDefs;
    static TestFieldColImpl altFieldDefs;
    static PrintStream os;

    protected void create_fields() throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy, MMMM dd HH:mm:ss");
        fieldDefs = new TestFieldColImpl();
        fieldDefs.addField(new TestFieldImpl("i0", 1, false, new Integer(0)));
        fieldDefs.addField(new TestFieldImpl("i1", 1, false, new Integer(1)));
        fieldDefs.addField(new TestFieldImpl("i2", 1, false, new Integer(5)));
        fieldDefs.addField(new TestFieldImpl("i3", 1, false, new Integer(-1)));
        fieldDefs.addField(new TestFieldImpl("i4", 1, false, new Integer(2000000000)));
        fieldDefs.addField(new TestFieldImpl("i5", 1, false, new Integer(-2000000000)));
        fieldDefs.addField(new TestFieldImpl("s0", 2, false, new String("")));
        fieldDefs.addField(new TestFieldImpl("s1", 2, false, new String("x")));
        fieldDefs.addField(new TestFieldImpl("s2", 2, false, new String("abcdef")));
        fieldDefs.addField(new TestFieldImpl("s3", 2, false, new String("1234567890123456789012345678901234567890")));
        fieldDefs.addField(new TestFieldImpl("b0", 4, false, new Boolean(false)));
        fieldDefs.addField(new TestFieldImpl("b1", 4, false, new Boolean(true)));
        fieldDefs.addField(new TestFieldImpl("f0", 8, false, new Double(0.0)));
        fieldDefs.addField(new TestFieldImpl("f1", 8, false, new Double(1.0)));
        fieldDefs.addField(new TestFieldImpl("f2", 8, false, new Double(5.0)));
        fieldDefs.addField(new TestFieldImpl("f3", 8, false, new Double(-1.0)));
        fieldDefs.addField(new TestFieldImpl("f4", 8, false, new Double(1.23456789)));
        fieldDefs.addField(new TestFieldImpl("f5", 8, false, new Double(1.0E100)));
        fieldDefs.addField(new TestFieldImpl("f6", 8, false, new Double(-1.234E-56)));
        fieldDefs.addField(new TestFieldImpl("t0", 16, false, formatter.parse("1970, January 1 00:00:00", new ParsePosition(0))));
        fieldDefs.addField(new TestFieldImpl("t1", 16, false, formatter.parse("1996, December 25 12:34:56", new ParsePosition(0))));
        fieldDefs.addField(new TestFieldImpl("t2", 16, false, formatter.parse("1953, February 28 3:04:05", new ParsePosition(0))));
        Integer[] ai = new Integer[]{new Integer(0), new Integer(1), new Integer(5), new Integer(-1), new Integer(2000000000), new Integer(-2000000000)};
        fieldDefs.addField(new TestFieldImpl("ia0", 1, true, ai));
        String[] as = new String[]{new String(""), new String("x"), new String("abcdef"), new String("1234567890123456789012345678901234567890")};
        fieldDefs.addField(new TestFieldImpl("sa0", 2, true, as));
        Boolean[] ab = new Boolean[]{new Boolean(false), new Boolean(true)};
        fieldDefs.addField(new TestFieldImpl("ba0", 4, true, ab));
        Double[] af = new Double[]{new Double(0.0), new Double(1.0), new Double(5.0), new Double(-1.0), new Double(1.23456789), new Double(1.0E100), new Double(-1.234E-56)};
        fieldDefs.addField(new TestFieldImpl("fa0", 8, true, af));
        Date[] at = new Date[]{formatter.parse("1970, January 1 00:00:00", new ParsePosition(0)), formatter.parse("1996, December 25 12:34:56", new ParsePosition(0)), formatter.parse("1953, February 28 3:04:05", new ParsePosition(0))};
        fieldDefs.addField(new TestFieldImpl("ta0", 16, true, at));
        altFieldDefs = new TestFieldColImpl();
        altFieldDefs.addField(new TestFieldImpl("ai0", 1, false, new Integer(0)));
        altFieldDefs.addField(new TestFieldImpl("ai1", 1, false, new Integer(1)));
        altFieldDefs.addField(new TestFieldImpl("ai2", 1, false, new Integer(5)));
        altFieldDefs.addField(new TestFieldImpl("ai3", 1, false, new Integer(-1)));
        altFieldDefs.addField(new TestFieldImpl("ai4", 1, false, new Integer(2000000000)));
        altFieldDefs.addField(new TestFieldImpl("ai5", 1, false, new Integer(-2000000000)));
        altFieldDefs.addField(new TestFieldImpl("as0", 2, false, new String("")));
        altFieldDefs.addField(new TestFieldImpl("as1", 2, false, new String("x")));
        altFieldDefs.addField(new TestFieldImpl("as2", 2, false, new String("abcdef")));
        altFieldDefs.addField(new TestFieldImpl("as3", 2, false, new String("1234567890123456789012345678901234567890")));
        altFieldDefs.addField(new TestFieldImpl("ab0", 4, false, new Boolean(false)));
        altFieldDefs.addField(new TestFieldImpl("ab1", 4, false, new Boolean(true)));
        altFieldDefs.addField(new TestFieldImpl("af0", 8, false, new Double(0.0)));
        altFieldDefs.addField(new TestFieldImpl("af1", 8, false, new Double(1.0)));
        altFieldDefs.addField(new TestFieldImpl("af2", 8, false, new Double(5.0)));
        altFieldDefs.addField(new TestFieldImpl("af3", 8, false, new Double(-1.0)));
        altFieldDefs.addField(new TestFieldImpl("af4", 8, false, new Double(1.23456789)));
        altFieldDefs.addField(new TestFieldImpl("af5", 8, false, new Double(1.0E100)));
        altFieldDefs.addField(new TestFieldImpl("af6", 8, false, new Double(-1.234E-56)));
        altFieldDefs.addField(new TestFieldImpl("at0", 16, false, formatter.parse("1970, January 1 00:00:00", new ParsePosition(0))));
        altFieldDefs.addField(new TestFieldImpl("at1", 16, false, formatter.parse("1996, December 25 12:34:56", new ParsePosition(0))));
        altFieldDefs.addField(new TestFieldImpl("at2", 16, false, formatter.parse("1953, February 28 3:04:05", new ParsePosition(0))));
        Integer[] aai = new Integer[]{new Integer(0), new Integer(1), new Integer(5), new Integer(-1), new Integer(2000000000), new Integer(-2000000000)};
        altFieldDefs.addField(new TestFieldImpl("aia0", 1, true, aai));
        String[] aas = new String[]{new String(""), new String("x"), new String("abcdef"), new String("1234567890123456789012345678901234567890")};
        altFieldDefs.addField(new TestFieldImpl("asa0", 2, true, aas));
        Boolean[] aab = new Boolean[]{new Boolean(false), new Boolean(true)};
        altFieldDefs.addField(new TestFieldImpl("aba0", 4, true, aab));
        Double[] aaf = new Double[]{new Double(0.0), new Double(1.0), new Double(5.0), new Double(-1.0), new Double(1.23456789), new Double(1.0E100), new Double(-1.234E-56)};
        altFieldDefs.addField(new TestFieldImpl("afa0", 8, true, aaf));
        Date[] aat = new Date[]{formatter.parse("1970, January 1 00:00:00", new ParsePosition(0)), formatter.parse("1996, December 25 12:34:56", new ParsePosition(0)), formatter.parse("1953, February 28 3:04:05", new ParsePosition(0))};
        altFieldDefs.addField(new TestFieldImpl("ata0", 16, true, aat));
    }

    protected static void usage(String errMsg) {
        if (errMsg != null) {
            os.print(errMsg + "\n");
        }
        os.print("Usage: jvwexptst [-o] [-d] [-r <reps>] [infile outfile]\n");
        os.print("       -o:  output opcodes\n");
        os.print("       -x:  debug traces the parser execution\n");
        os.print("       -d:  debug traces the runtime expression execution (pushes and pops)\n");
        os.print("       -r <reps>:  execute each expression <reps> times and report timings\n");
        os.print("       infile:  input file of expressions (implies non-interactive)\n");
        os.print("       outfile:  output file of expression evaluations or timings\n");
        System.exit(1);
    }

    private void show_hints() {
        os.print("Alternate ($) fields are identical except that their names start with 'a'.\n");
        os.print("Reference expressions are indicated by prefixing them with ':='.\n");
        os.print("Implicit conversions are indicated by prefixing them with '::' and \n");
        os.print("   using a ';' after the conversion (e.g. '::integer;1.0').\n");
        os.print("type 'h' or '?' to repeat this information.\n");
    }

    private void show_initial_field_values() {
        os.print("Fields:\n");
        os.print("i0:integer(0) ");
        os.print("i1:integer(1) ");
        os.print("i2:integer(5) ");
        os.print("i3:integer(-1) ");
        os.print("i4:integer(2000000000)\n");
        os.print("i5:integer(-2000000000) ");
        os.print("s0:string('') ");
        os.print("s1:string('x') ");
        os.print("s2:string('abcdef')\n");
        os.print("s3:string('1234567890123456789012345678901234567890') ");
        os.print("b0:boolean(false)\n");
        os.print("b1:boolean(true) ");
        os.print("f0:float(0.0) ");
        os.print("f1:float(1.0) ");
        os.print("f2:float(5.0) ");
        os.print("f3:float(-1.0)\n");
        os.print("f4:float(1.23456789) ");
        os.print("f5:float(1e100) ");
        os.print("f6:float(-1.234e-56)\n");
        os.print("t0:time('1970, January 1 00:00:00') ");
        os.print("t1:time('1996, December 25 12:34:56')\n");
        os.print("t2:time('1953, February 28 3:04:05') ");
        os.print("\n");
        os.print("ia0:integer[]({0,1,5,-1,2000000000,-2000000000})\n");
        os.print("sa0:string({'','x','abcdef','1234567890123456789012345678901234567890'})\n");
        os.print("ba0:boolean({false,true})\n");
        os.print("fa0:float({0.0,1.0,5.0,-1.0,1.23456789,1e100,-1.234e-56})\n");
        os.print("ta0:time({'1970, January 1 00:00:00','1996, December 25 12:34:56','1953, February 28 3:04:05'})\n");
    }

    private static void print_syntax_errors(String[] errors, String expr) {
        if (errors == null) {
            return;
        }
        os.print("    >>>Expression error!<<<\n");
        if (expr != null) {
            os.print("    " + expr + "\n");
            os.print("    123456789_123456789_123456789_123456789_123456789_123456789_123456789\n");
        }
        for (int i = 0; i < errors.length; ++i) {
            os.print("   " + errors[i] + "\n");
        }
    }

    private static void output_object(Object res) throws Exception {
        if (!VWFieldType.isValid(res)) {
            throw new Exception("Type of res parameter," + res.getClass().toString() + ", is not a valid field value");
        }
        if (res instanceof Integer) {
            os.print("    Integer:       ");
        } else if (res instanceof Double) {
            os.print("    Float:         ");
        } else if (res instanceof String) {
            os.print("    String:        ");
        } else if (res instanceof Boolean) {
            os.print("    Boolean:       ");
        } else if (res instanceof Date) {
            os.print("    Time:          ");
        } else if (res.getClass().isArray()) {
            os.print("----Array\n");
            int size = ((Object[])res).length;
            for (int i = 0; i < size; ++i) {
                jvwexptst.output_object(((Object[])res)[i]);
            }
            os.print("----\n");
        }
        if (!res.getClass().isArray()) {
            os.print(">>>" + String.valueOf(res) + "<<<\n");
        }
    }

    protected jvwexptst() {
    }

    public static void main(String[] args) {
        boolean opcodesFlag = false;
        boolean parserDebugFlag = false;
        boolean exprDebugFlag = false;
        boolean useFile = false;
        boolean useRef = false;
        boolean useConv = false;
        LineNumberReader lnr = null;
        File inputFile = null;
        String str = null;
        String[] errStrs = null;
        VWCompiledExpr outExpr = null;
        Object res = null;
        Hashtable<String, Object> myEnvData = new Hashtable<String, Object>();
        myEnvData.put("UserId", "JohnSmith");
        myEnvData.put("SimDistributions", Distributions.getInstance());
        try {
            jvwexptst vwexptst1 = new jvwexptst();
            String inFileName = null;
            String outFileName = null;
            long repetitions = 0L;
            for (int argIdx = 0; argIdx < args.length; ++argIdx) {
                if (args[argIdx].equalsIgnoreCase("-o")) {
                    opcodesFlag = true;
                    continue;
                }
                if (args[argIdx].startsWith("-r")) {
                    if (args[argIdx].length() > 2) {
                        repetitions = Long.parseLong(args[argIdx].substring(2));
                        continue;
                    }
                    if (++argIdx == args.length) {
                        jvwexptst.usage("Missing repetition count after -r argument");
                    }
                    repetitions = Long.parseLong(args[argIdx]);
                    continue;
                }
                if (args[argIdx].startsWith("-x")) {
                    parserDebugFlag = true;
                    VWExpr.debug(true);
                    continue;
                }
                if (args[argIdx].startsWith("-d")) {
                    exprDebugFlag = true;
                    continue;
                }
                if (args[argIdx].startsWith("-?") || args[argIdx].startsWith("-h")) {
                    jvwexptst.usage(null);
                    continue;
                }
                if (args[argIdx].startsWith("-")) {
                    jvwexptst.usage("Invalid option " + args[argIdx]);
                    continue;
                }
                if (inFileName == null) {
                    inFileName = args[argIdx];
                    inputFile = new File(args[argIdx]);
                    if (!inputFile.canRead()) {
                        jvwexptst.usage("Can't read input file <" + args[argIdx] + ">");
                        continue;
                    }
                    lnr = new LineNumberReader(new FileReader(inFileName));
                    useFile = true;
                    continue;
                }
                if (outFileName != null) continue;
                outFileName = args[argIdx];
                try {
                    os = new PrintStream(new FileOutputStream(outFileName));
                    continue;
                }
                catch (Exception e) {
                    jvwexptst.usage("Can't open output file <" + args[argIdx] + "> " + e.toString());
                }
            }
            if (inputFile != null) {
                os.print("Input file : " + inputFile.getAbsolutePath() + "\n");
            }
            if (lnr == null) {
                lnr = new LineNumberReader(new InputStreamReader(System.in));
            }
            vwexptst1.create_fields();
            if (!useFile) {
                vwexptst1.show_initial_field_values();
                vwexptst1.show_hints();
            }
            try {
                while (true) {
                    if (!useFile) {
                        System.out.print("Expression?  ");
                    }
                    if ((str = lnr.readLine()) == null || str.equalsIgnoreCase("q") || str.equalsIgnoreCase("quit") || str.equalsIgnoreCase("exit") || str.equalsIgnoreCase("x")) break;
                    if (str.length() == 0) continue;
                    if (str.startsWith("\"--\"")) {
                        os.print(str + "\n");
                        if (useRef) continue;
                        jvwexptst.output_object("--");
                        continue;
                    }
                    if (str.equalsIgnoreCase("h") || str.equalsIgnoreCase("help") || str.equalsIgnoreCase("?")) {
                        vwexptst1.show_initial_field_values();
                        vwexptst1.show_hints();
                        continue;
                    }
                    if (str.equalsIgnoreCase("w") || str.equalsIgnoreCase("wobs")) {
                        vwexptst1.dump_wobs();
                        continue;
                    }
                    if (useFile) {
                        os.print(str + "\n");
                    } else {
                        os.print("Expr=[" + str + "]\n");
                    }
                    res = null;
                    useRef = str.startsWith(":=");
                    useConv = str.startsWith("::");
                    if (useRef) {
                        outExpr = new VWCompiledRefExpr();
                        outExpr.debug(exprDebugFlag, System.out);
                    } else {
                        outExpr = new VWCompiledExpr();
                        outExpr.debug(exprDebugFlag, System.out);
                    }
                    errStrs = VWExpr.compileVWExpr(str, fieldDefs, altFieldDefs, true, outExpr);
                    if (errStrs != null) {
                        jvwexptst.print_syntax_errors(errStrs, str);
                        continue;
                    }
                    if (!useFile) {
                        os.print("Result compiled type = ");
                        if (outExpr.getResultIsArray()) {
                            os.print("Array of ");
                        }
                        os.print(VWFieldType.getLocalizedString(outExpr.getResultType()) + "\n");
                    }
                    if (opcodesFlag) {
                        os.print("OPCODES are:  " + outExpr.toString() + "\n");
                    }
                    if (repetitions > 0L) {
                        long count;
                        ATimer t1 = null;
                        if (useRef) {
                            t1 = new ATimer();
                            for (count = 0L; count < repetitions; ++count) {
                                res = outExpr.execute(fieldDefs, altFieldDefs, myEnvData);
                            }
                        } else {
                            t1 = new ATimer();
                            for (count = 0L; count < repetitions; ++count) {
                                res = outExpr.execute(fieldDefs, altFieldDefs, myEnvData);
                            }
                        }
                        os.print(String.valueOf(t1.getElapsed()) + " milliseconds elapsed time (" + String.valueOf(repetitions) + " repetitions)\n");
                        continue;
                    }
                    if (!useFile) {
                        os.print("Evaluating expression...\n");
                    }
                    try {
                        res = useRef ? outExpr.execute(fieldDefs, altFieldDefs, myEnvData) : outExpr.execute(fieldDefs, altFieldDefs, myEnvData);
                    }
                    catch (Exception e) {
                        os.print("    >>>Exception:  " + e.getMessage() + "<<\n");
                        continue;
                    }
                    if (!useFile && !useRef) {
                        os.print("Result type = ");
                        if (outExpr.getResultIsArray()) {
                            os.print("Array of ");
                        }
                        os.print(VWFieldType.getLocalizedString(outExpr.getResultType()) + "\n");
                    }
                    if (!useRef) {
                        jvwexptst.output_object(res);
                        continue;
                    }
                    os.println("Field Name = " + ((VWCompiledRefExpr)outExpr).getName());
                    os.println("Alternate = " + String.valueOf(((VWCompiledRefExpr)outExpr).getIsAlt()));
                    if (!((VWCompiledRefExpr)outExpr).getIsIndexed()) continue;
                    os.println("The expression is an indexed array element, and the index is " + res.toString());
                }
            }
            catch (EOFException eofE) {
            }
        }
        catch (Exception e) {
            System.out.println("e.toString() = " + e.toString() + " , e.getMessage() = " + e.getMessage());
            System.out.println("");
            e.printStackTrace();
        }
    }

    private void dump_wobs() throws Exception {
        Enumeration altFieldDefs_Fields;
        Enumeration fieldDefs_Fields = fieldDefs.getFields();
        if (fieldDefs_Fields != null) {
            System.out.print("FIELDS FROM fieldDefs\n");
            while (fieldDefs_Fields.hasMoreElements()) {
                System.out.print("   " + fieldDefs_Fields.nextElement().toString() + "\n");
            }
        } else {
            System.out.print("Got a null enumeration for the fields of fieldDefs.\n");
        }
        if ((altFieldDefs_Fields = altFieldDefs.getFields()) != null) {
            System.out.print("FIELDS FROM altFieldDefs\n");
            while (altFieldDefs_Fields.hasMoreElements()) {
                System.out.print("   " + altFieldDefs_Fields.nextElement().toString() + "\n");
            }
        } else {
            System.out.print("Got a null enumeration for the fields of altFieldDefs.\n");
        }
    }

    static {
        os = System.out;
    }
}

